#region Using declarations
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows;
using System.Windows.Input;
using System.Windows.Media;
using System.Xml.Serialization;
using NinjaTrader.Cbi;
using NinjaTrader.Gui;
using NinjaTrader.Gui.Chart;
using NinjaTrader.Gui.SuperDom;
using NinjaTrader.Gui.Tools;
using NinjaTrader.Data;
using NinjaTrader.NinjaScript;
using NinjaTrader.Core.FloatingPoint;

#endregion



#region NinjaScript generated code. Neither change nor remove.

namespace NinjaTrader.NinjaScript.Indicators
{
	public partial class Indicator : NinjaTrader.Gui.NinjaScript.IndicatorRenderBase
	{
		
		private BuySideGlobal.BSDLevels[] cacheBSDLevels;
		private BuySideGlobal.BSDOrderFlowZones[] cacheBSDOrderFlowZones;
		private BuySideGlobal.BSDSupplyDemand[] cacheBSDSupplyDemand;
		private BuySideGlobal.BSDTrailingStop[] cacheBSDTrailingStop;
		private BuySideGlobal.BSDZoneEntrySignals[] cacheBSDZoneEntrySignals;

		
		public BuySideGlobal.BSDLevels BSDLevels(bool active2, bool active3)
		{
			return BSDLevels(Input, active2, active3);
		}

		public BuySideGlobal.BSDOrderFlowZones BSDOrderFlowZones(bool showEntryLine, int entryLineOffset, bool bGMTAEnabled, bool bGMTAShowZones, int bGMTAPeriod, int highTFLineWidth, BarsPeriodType bGMTAPeriodType, Brush bGMTABuy, Brush bGMTASell, bool bGTrend, string buyZoneAlarm, string sellZoneAlarm, Brush longColor, Brush shortColor, int mainTFLineWidth)
		{
			return BSDOrderFlowZones(Input, showEntryLine, entryLineOffset, bGMTAEnabled, bGMTAShowZones, bGMTAPeriod, highTFLineWidth, bGMTAPeriodType, bGMTABuy, bGMTASell, bGTrend, buyZoneAlarm, sellZoneAlarm, longColor, shortColor, mainTFLineWidth);
		}

		public BuySideGlobal.BSDSupplyDemand BSDSupplyDemand(Brush supplyStrong, Brush supplyRetouch, Brush supplyZoneBorder, Brush demandStrong, Brush demandRetouch, Brush demandZoneBorder, Brush textColor, int strongOpacity, int retouchOpacity, bool showHistory, bool showOnlyPriorZones, bool recolorRetouch, bool extendZone, bool displayZoneConfirm, int extendZoneMinutes, int priorZoneDaysBack, int valueGapFactor, bool farEdgePrice, bool mainEdgePrice, bool zoneHeight, bool retestEnabled, string retestAlert)
		{
			return BSDSupplyDemand(Input, supplyStrong, supplyRetouch, supplyZoneBorder, demandStrong, demandRetouch, demandZoneBorder, textColor, strongOpacity, retouchOpacity, showHistory, showOnlyPriorZones, recolorRetouch, extendZone, displayZoneConfirm, extendZoneMinutes, priorZoneDaysBack, valueGapFactor, farEdgePrice, mainEdgePrice, zoneHeight, retestEnabled, retestAlert);
		}

		public BuySideGlobal.BSDTrailingStop BSDTrailingStop(Brush upcolor1, int alpha, int beta, int gamma, bool colorbar, bool smooth, Brush dncolor1, Brush flatcolor1)
		{
			return BSDTrailingStop(Input, upcolor1, alpha, beta, gamma, colorbar, smooth, dncolor1, flatcolor1);
		}

		public BuySideGlobal.BSDZoneEntrySignals BSDZoneEntrySignals(bool retestAsStrongZones, int retestCountStrongZones, int breakoutMinRestRequired, bool resetZonesForNewTradingDay, bool strongZoneBreakAndRetest, bool higherHighsAndLowerLows, bool zoneBreakAndZoneSwap, bool signalBreakAndRestart, bool strongZoneBounce)
		{
			return BSDZoneEntrySignals(Input, retestAsStrongZones, retestCountStrongZones, breakoutMinRestRequired, resetZonesForNewTradingDay, strongZoneBreakAndRetest, higherHighsAndLowerLows, zoneBreakAndZoneSwap, signalBreakAndRestart, strongZoneBounce);
		}


		
		public BuySideGlobal.BSDLevels BSDLevels(ISeries<double> input, bool active2, bool active3)
		{
			if (cacheBSDLevels != null)
				for (int idx = 0; idx < cacheBSDLevels.Length; idx++)
					if (cacheBSDLevels[idx].Active2 == active2 && cacheBSDLevels[idx].Active3 == active3 && cacheBSDLevels[idx].EqualsInput(input))
						return cacheBSDLevels[idx];
			return CacheIndicator<BuySideGlobal.BSDLevels>(new BuySideGlobal.BSDLevels(){ Active2 = active2, Active3 = active3 }, input, ref cacheBSDLevels);
		}

		public BuySideGlobal.BSDOrderFlowZones BSDOrderFlowZones(ISeries<double> input, bool showEntryLine, int entryLineOffset, bool bGMTAEnabled, bool bGMTAShowZones, int bGMTAPeriod, int highTFLineWidth, BarsPeriodType bGMTAPeriodType, Brush bGMTABuy, Brush bGMTASell, bool bGTrend, string buyZoneAlarm, string sellZoneAlarm, Brush longColor, Brush shortColor, int mainTFLineWidth)
		{
			if (cacheBSDOrderFlowZones != null)
				for (int idx = 0; idx < cacheBSDOrderFlowZones.Length; idx++)
					if (cacheBSDOrderFlowZones[idx].ShowEntryLine == showEntryLine && cacheBSDOrderFlowZones[idx].EntryLineOffset == entryLineOffset && cacheBSDOrderFlowZones[idx].BGMTAEnabled == bGMTAEnabled && cacheBSDOrderFlowZones[idx].BGMTAShowZones == bGMTAShowZones && cacheBSDOrderFlowZones[idx].BGMTAPeriod == bGMTAPeriod && cacheBSDOrderFlowZones[idx].HighTFLineWidth == highTFLineWidth && cacheBSDOrderFlowZones[idx].BGMTAPeriodType == bGMTAPeriodType && cacheBSDOrderFlowZones[idx].BGMTABuy == bGMTABuy && cacheBSDOrderFlowZones[idx].BGMTASell == bGMTASell && cacheBSDOrderFlowZones[idx].BGTrend == bGTrend && cacheBSDOrderFlowZones[idx].BuyZoneAlarm == buyZoneAlarm && cacheBSDOrderFlowZones[idx].SellZoneAlarm == sellZoneAlarm && cacheBSDOrderFlowZones[idx].LongColor == longColor && cacheBSDOrderFlowZones[idx].ShortColor == shortColor && cacheBSDOrderFlowZones[idx].MainTFLineWidth == mainTFLineWidth && cacheBSDOrderFlowZones[idx].EqualsInput(input))
						return cacheBSDOrderFlowZones[idx];
			return CacheIndicator<BuySideGlobal.BSDOrderFlowZones>(new BuySideGlobal.BSDOrderFlowZones(){ ShowEntryLine = showEntryLine, EntryLineOffset = entryLineOffset, BGMTAEnabled = bGMTAEnabled, BGMTAShowZones = bGMTAShowZones, BGMTAPeriod = bGMTAPeriod, HighTFLineWidth = highTFLineWidth, BGMTAPeriodType = bGMTAPeriodType, BGMTABuy = bGMTABuy, BGMTASell = bGMTASell, BGTrend = bGTrend, BuyZoneAlarm = buyZoneAlarm, SellZoneAlarm = sellZoneAlarm, LongColor = longColor, ShortColor = shortColor, MainTFLineWidth = mainTFLineWidth }, input, ref cacheBSDOrderFlowZones);
		}

		public BuySideGlobal.BSDSupplyDemand BSDSupplyDemand(ISeries<double> input, Brush supplyStrong, Brush supplyRetouch, Brush supplyZoneBorder, Brush demandStrong, Brush demandRetouch, Brush demandZoneBorder, Brush textColor, int strongOpacity, int retouchOpacity, bool showHistory, bool showOnlyPriorZones, bool recolorRetouch, bool extendZone, bool displayZoneConfirm, int extendZoneMinutes, int priorZoneDaysBack, int valueGapFactor, bool farEdgePrice, bool mainEdgePrice, bool zoneHeight, bool retestEnabled, string retestAlert)
		{
			if (cacheBSDSupplyDemand != null)
				for (int idx = 0; idx < cacheBSDSupplyDemand.Length; idx++)
					if (cacheBSDSupplyDemand[idx].SupplyStrong == supplyStrong && cacheBSDSupplyDemand[idx].SupplyRetouch == supplyRetouch && cacheBSDSupplyDemand[idx].SupplyZoneBorder == supplyZoneBorder && cacheBSDSupplyDemand[idx].DemandStrong == demandStrong && cacheBSDSupplyDemand[idx].DemandRetouch == demandRetouch && cacheBSDSupplyDemand[idx].DemandZoneBorder == demandZoneBorder && cacheBSDSupplyDemand[idx].TextColor == textColor && cacheBSDSupplyDemand[idx].StrongOpacity == strongOpacity && cacheBSDSupplyDemand[idx].RetouchOpacity == retouchOpacity && cacheBSDSupplyDemand[idx].ShowHistory == showHistory && cacheBSDSupplyDemand[idx].ShowOnlyPriorZones == showOnlyPriorZones && cacheBSDSupplyDemand[idx].RecolorRetouch == recolorRetouch && cacheBSDSupplyDemand[idx].ExtendZone == extendZone && cacheBSDSupplyDemand[idx].DisplayZoneConfirm == displayZoneConfirm && cacheBSDSupplyDemand[idx].ExtendZoneMinutes == extendZoneMinutes && cacheBSDSupplyDemand[idx].PriorZoneDaysBack == priorZoneDaysBack && cacheBSDSupplyDemand[idx].ValueGapFactor == valueGapFactor && cacheBSDSupplyDemand[idx].FarEdgePrice == farEdgePrice && cacheBSDSupplyDemand[idx].MainEdgePrice == mainEdgePrice && cacheBSDSupplyDemand[idx].ZoneHeight == zoneHeight && cacheBSDSupplyDemand[idx].RetestEnabled == retestEnabled && cacheBSDSupplyDemand[idx].RetestAlert == retestAlert && cacheBSDSupplyDemand[idx].EqualsInput(input))
						return cacheBSDSupplyDemand[idx];
			return CacheIndicator<BuySideGlobal.BSDSupplyDemand>(new BuySideGlobal.BSDSupplyDemand(){ SupplyStrong = supplyStrong, SupplyRetouch = supplyRetouch, SupplyZoneBorder = supplyZoneBorder, DemandStrong = demandStrong, DemandRetouch = demandRetouch, DemandZoneBorder = demandZoneBorder, TextColor = textColor, StrongOpacity = strongOpacity, RetouchOpacity = retouchOpacity, ShowHistory = showHistory, ShowOnlyPriorZones = showOnlyPriorZones, RecolorRetouch = recolorRetouch, ExtendZone = extendZone, DisplayZoneConfirm = displayZoneConfirm, ExtendZoneMinutes = extendZoneMinutes, PriorZoneDaysBack = priorZoneDaysBack, ValueGapFactor = valueGapFactor, FarEdgePrice = farEdgePrice, MainEdgePrice = mainEdgePrice, ZoneHeight = zoneHeight, RetestEnabled = retestEnabled, RetestAlert = retestAlert }, input, ref cacheBSDSupplyDemand);
		}

		public BuySideGlobal.BSDTrailingStop BSDTrailingStop(ISeries<double> input, Brush upcolor1, int alpha, int beta, int gamma, bool colorbar, bool smooth, Brush dncolor1, Brush flatcolor1)
		{
			if (cacheBSDTrailingStop != null)
				for (int idx = 0; idx < cacheBSDTrailingStop.Length; idx++)
					if (cacheBSDTrailingStop[idx].upcolor1 == upcolor1 && cacheBSDTrailingStop[idx].alpha == alpha && cacheBSDTrailingStop[idx].beta == beta && cacheBSDTrailingStop[idx].gamma == gamma && cacheBSDTrailingStop[idx].colorbar == colorbar && cacheBSDTrailingStop[idx].smooth == smooth && cacheBSDTrailingStop[idx].dncolor1 == dncolor1 && cacheBSDTrailingStop[idx].flatcolor1 == flatcolor1 && cacheBSDTrailingStop[idx].EqualsInput(input))
						return cacheBSDTrailingStop[idx];
			return CacheIndicator<BuySideGlobal.BSDTrailingStop>(new BuySideGlobal.BSDTrailingStop(){ upcolor1 = upcolor1, alpha = alpha, beta = beta, gamma = gamma, colorbar = colorbar, smooth = smooth, dncolor1 = dncolor1, flatcolor1 = flatcolor1 }, input, ref cacheBSDTrailingStop);
		}

		public BuySideGlobal.BSDZoneEntrySignals BSDZoneEntrySignals(ISeries<double> input, bool retestAsStrongZones, int retestCountStrongZones, int breakoutMinRestRequired, bool resetZonesForNewTradingDay, bool strongZoneBreakAndRetest, bool higherHighsAndLowerLows, bool zoneBreakAndZoneSwap, bool signalBreakAndRestart, bool strongZoneBounce)
		{
			if (cacheBSDZoneEntrySignals != null)
				for (int idx = 0; idx < cacheBSDZoneEntrySignals.Length; idx++)
					if (cacheBSDZoneEntrySignals[idx].RetestAsStrongZones == retestAsStrongZones && cacheBSDZoneEntrySignals[idx].RetestCountStrongZones == retestCountStrongZones && cacheBSDZoneEntrySignals[idx].BreakoutMinRestRequired == breakoutMinRestRequired && cacheBSDZoneEntrySignals[idx].ResetZonesForNewTradingDay == resetZonesForNewTradingDay && cacheBSDZoneEntrySignals[idx].StrongZoneBreakAndRetest == strongZoneBreakAndRetest && cacheBSDZoneEntrySignals[idx].HigherHighsAndLowerLows == higherHighsAndLowerLows && cacheBSDZoneEntrySignals[idx].ZoneBreakAndZoneSwap == zoneBreakAndZoneSwap && cacheBSDZoneEntrySignals[idx].SignalBreakAndRestart == signalBreakAndRestart && cacheBSDZoneEntrySignals[idx].StrongZoneBounce == strongZoneBounce && cacheBSDZoneEntrySignals[idx].EqualsInput(input))
						return cacheBSDZoneEntrySignals[idx];
			return CacheIndicator<BuySideGlobal.BSDZoneEntrySignals>(new BuySideGlobal.BSDZoneEntrySignals(){ RetestAsStrongZones = retestAsStrongZones, RetestCountStrongZones = retestCountStrongZones, BreakoutMinRestRequired = breakoutMinRestRequired, ResetZonesForNewTradingDay = resetZonesForNewTradingDay, StrongZoneBreakAndRetest = strongZoneBreakAndRetest, HigherHighsAndLowerLows = higherHighsAndLowerLows, ZoneBreakAndZoneSwap = zoneBreakAndZoneSwap, SignalBreakAndRestart = signalBreakAndRestart, StrongZoneBounce = strongZoneBounce }, input, ref cacheBSDZoneEntrySignals);
		}

	}
}

namespace NinjaTrader.NinjaScript.MarketAnalyzerColumns
{
	public partial class MarketAnalyzerColumn : MarketAnalyzerColumnBase
	{
		
		public Indicators.BuySideGlobal.BSDLevels BSDLevels(bool active2, bool active3)
		{
			return indicator.BSDLevels(Input, active2, active3);
		}

		public Indicators.BuySideGlobal.BSDOrderFlowZones BSDOrderFlowZones(bool showEntryLine, int entryLineOffset, bool bGMTAEnabled, bool bGMTAShowZones, int bGMTAPeriod, int highTFLineWidth, BarsPeriodType bGMTAPeriodType, Brush bGMTABuy, Brush bGMTASell, bool bGTrend, string buyZoneAlarm, string sellZoneAlarm, Brush longColor, Brush shortColor, int mainTFLineWidth)
		{
			return indicator.BSDOrderFlowZones(Input, showEntryLine, entryLineOffset, bGMTAEnabled, bGMTAShowZones, bGMTAPeriod, highTFLineWidth, bGMTAPeriodType, bGMTABuy, bGMTASell, bGTrend, buyZoneAlarm, sellZoneAlarm, longColor, shortColor, mainTFLineWidth);
		}

		public Indicators.BuySideGlobal.BSDSupplyDemand BSDSupplyDemand(Brush supplyStrong, Brush supplyRetouch, Brush supplyZoneBorder, Brush demandStrong, Brush demandRetouch, Brush demandZoneBorder, Brush textColor, int strongOpacity, int retouchOpacity, bool showHistory, bool showOnlyPriorZones, bool recolorRetouch, bool extendZone, bool displayZoneConfirm, int extendZoneMinutes, int priorZoneDaysBack, int valueGapFactor, bool farEdgePrice, bool mainEdgePrice, bool zoneHeight, bool retestEnabled, string retestAlert)
		{
			return indicator.BSDSupplyDemand(Input, supplyStrong, supplyRetouch, supplyZoneBorder, demandStrong, demandRetouch, demandZoneBorder, textColor, strongOpacity, retouchOpacity, showHistory, showOnlyPriorZones, recolorRetouch, extendZone, displayZoneConfirm, extendZoneMinutes, priorZoneDaysBack, valueGapFactor, farEdgePrice, mainEdgePrice, zoneHeight, retestEnabled, retestAlert);
		}

		public Indicators.BuySideGlobal.BSDTrailingStop BSDTrailingStop(Brush upcolor1, int alpha, int beta, int gamma, bool colorbar, bool smooth, Brush dncolor1, Brush flatcolor1)
		{
			return indicator.BSDTrailingStop(Input, upcolor1, alpha, beta, gamma, colorbar, smooth, dncolor1, flatcolor1);
		}

		public Indicators.BuySideGlobal.BSDZoneEntrySignals BSDZoneEntrySignals(bool retestAsStrongZones, int retestCountStrongZones, int breakoutMinRestRequired, bool resetZonesForNewTradingDay, bool strongZoneBreakAndRetest, bool higherHighsAndLowerLows, bool zoneBreakAndZoneSwap, bool signalBreakAndRestart, bool strongZoneBounce)
		{
			return indicator.BSDZoneEntrySignals(Input, retestAsStrongZones, retestCountStrongZones, breakoutMinRestRequired, resetZonesForNewTradingDay, strongZoneBreakAndRetest, higherHighsAndLowerLows, zoneBreakAndZoneSwap, signalBreakAndRestart, strongZoneBounce);
		}


		
		public Indicators.BuySideGlobal.BSDLevels BSDLevels(ISeries<double> input , bool active2, bool active3)
		{
			return indicator.BSDLevels(input, active2, active3);
		}

		public Indicators.BuySideGlobal.BSDOrderFlowZones BSDOrderFlowZones(ISeries<double> input , bool showEntryLine, int entryLineOffset, bool bGMTAEnabled, bool bGMTAShowZones, int bGMTAPeriod, int highTFLineWidth, BarsPeriodType bGMTAPeriodType, Brush bGMTABuy, Brush bGMTASell, bool bGTrend, string buyZoneAlarm, string sellZoneAlarm, Brush longColor, Brush shortColor, int mainTFLineWidth)
		{
			return indicator.BSDOrderFlowZones(input, showEntryLine, entryLineOffset, bGMTAEnabled, bGMTAShowZones, bGMTAPeriod, highTFLineWidth, bGMTAPeriodType, bGMTABuy, bGMTASell, bGTrend, buyZoneAlarm, sellZoneAlarm, longColor, shortColor, mainTFLineWidth);
		}

		public Indicators.BuySideGlobal.BSDSupplyDemand BSDSupplyDemand(ISeries<double> input , Brush supplyStrong, Brush supplyRetouch, Brush supplyZoneBorder, Brush demandStrong, Brush demandRetouch, Brush demandZoneBorder, Brush textColor, int strongOpacity, int retouchOpacity, bool showHistory, bool showOnlyPriorZones, bool recolorRetouch, bool extendZone, bool displayZoneConfirm, int extendZoneMinutes, int priorZoneDaysBack, int valueGapFactor, bool farEdgePrice, bool mainEdgePrice, bool zoneHeight, bool retestEnabled, string retestAlert)
		{
			return indicator.BSDSupplyDemand(input, supplyStrong, supplyRetouch, supplyZoneBorder, demandStrong, demandRetouch, demandZoneBorder, textColor, strongOpacity, retouchOpacity, showHistory, showOnlyPriorZones, recolorRetouch, extendZone, displayZoneConfirm, extendZoneMinutes, priorZoneDaysBack, valueGapFactor, farEdgePrice, mainEdgePrice, zoneHeight, retestEnabled, retestAlert);
		}

		public Indicators.BuySideGlobal.BSDTrailingStop BSDTrailingStop(ISeries<double> input , Brush upcolor1, int alpha, int beta, int gamma, bool colorbar, bool smooth, Brush dncolor1, Brush flatcolor1)
		{
			return indicator.BSDTrailingStop(input, upcolor1, alpha, beta, gamma, colorbar, smooth, dncolor1, flatcolor1);
		}

		public Indicators.BuySideGlobal.BSDZoneEntrySignals BSDZoneEntrySignals(ISeries<double> input , bool retestAsStrongZones, int retestCountStrongZones, int breakoutMinRestRequired, bool resetZonesForNewTradingDay, bool strongZoneBreakAndRetest, bool higherHighsAndLowerLows, bool zoneBreakAndZoneSwap, bool signalBreakAndRestart, bool strongZoneBounce)
		{
			return indicator.BSDZoneEntrySignals(input, retestAsStrongZones, retestCountStrongZones, breakoutMinRestRequired, resetZonesForNewTradingDay, strongZoneBreakAndRetest, higherHighsAndLowerLows, zoneBreakAndZoneSwap, signalBreakAndRestart, strongZoneBounce);
		}
	
	}
}

namespace NinjaTrader.NinjaScript.Strategies
{
	public partial class Strategy : NinjaTrader.Gui.NinjaScript.StrategyRenderBase
	{
		
		public Indicators.BuySideGlobal.BSDLevels BSDLevels(bool active2, bool active3)
		{
			return indicator.BSDLevels(Input, active2, active3);
		}

		public Indicators.BuySideGlobal.BSDOrderFlowZones BSDOrderFlowZones(bool showEntryLine, int entryLineOffset, bool bGMTAEnabled, bool bGMTAShowZones, int bGMTAPeriod, int highTFLineWidth, BarsPeriodType bGMTAPeriodType, Brush bGMTABuy, Brush bGMTASell, bool bGTrend, string buyZoneAlarm, string sellZoneAlarm, Brush longColor, Brush shortColor, int mainTFLineWidth)
		{
			return indicator.BSDOrderFlowZones(Input, showEntryLine, entryLineOffset, bGMTAEnabled, bGMTAShowZones, bGMTAPeriod, highTFLineWidth, bGMTAPeriodType, bGMTABuy, bGMTASell, bGTrend, buyZoneAlarm, sellZoneAlarm, longColor, shortColor, mainTFLineWidth);
		}

		public Indicators.BuySideGlobal.BSDSupplyDemand BSDSupplyDemand(Brush supplyStrong, Brush supplyRetouch, Brush supplyZoneBorder, Brush demandStrong, Brush demandRetouch, Brush demandZoneBorder, Brush textColor, int strongOpacity, int retouchOpacity, bool showHistory, bool showOnlyPriorZones, bool recolorRetouch, bool extendZone, bool displayZoneConfirm, int extendZoneMinutes, int priorZoneDaysBack, int valueGapFactor, bool farEdgePrice, bool mainEdgePrice, bool zoneHeight, bool retestEnabled, string retestAlert)
		{
			return indicator.BSDSupplyDemand(Input, supplyStrong, supplyRetouch, supplyZoneBorder, demandStrong, demandRetouch, demandZoneBorder, textColor, strongOpacity, retouchOpacity, showHistory, showOnlyPriorZones, recolorRetouch, extendZone, displayZoneConfirm, extendZoneMinutes, priorZoneDaysBack, valueGapFactor, farEdgePrice, mainEdgePrice, zoneHeight, retestEnabled, retestAlert);
		}

		public Indicators.BuySideGlobal.BSDTrailingStop BSDTrailingStop(Brush upcolor1, int alpha, int beta, int gamma, bool colorbar, bool smooth, Brush dncolor1, Brush flatcolor1)
		{
			return indicator.BSDTrailingStop(Input, upcolor1, alpha, beta, gamma, colorbar, smooth, dncolor1, flatcolor1);
		}

		public Indicators.BuySideGlobal.BSDZoneEntrySignals BSDZoneEntrySignals(bool retestAsStrongZones, int retestCountStrongZones, int breakoutMinRestRequired, bool resetZonesForNewTradingDay, bool strongZoneBreakAndRetest, bool higherHighsAndLowerLows, bool zoneBreakAndZoneSwap, bool signalBreakAndRestart, bool strongZoneBounce)
		{
			return indicator.BSDZoneEntrySignals(Input, retestAsStrongZones, retestCountStrongZones, breakoutMinRestRequired, resetZonesForNewTradingDay, strongZoneBreakAndRetest, higherHighsAndLowerLows, zoneBreakAndZoneSwap, signalBreakAndRestart, strongZoneBounce);
		}


		
		public Indicators.BuySideGlobal.BSDLevels BSDLevels(ISeries<double> input , bool active2, bool active3)
		{
			return indicator.BSDLevels(input, active2, active3);
		}

		public Indicators.BuySideGlobal.BSDOrderFlowZones BSDOrderFlowZones(ISeries<double> input , bool showEntryLine, int entryLineOffset, bool bGMTAEnabled, bool bGMTAShowZones, int bGMTAPeriod, int highTFLineWidth, BarsPeriodType bGMTAPeriodType, Brush bGMTABuy, Brush bGMTASell, bool bGTrend, string buyZoneAlarm, string sellZoneAlarm, Brush longColor, Brush shortColor, int mainTFLineWidth)
		{
			return indicator.BSDOrderFlowZones(input, showEntryLine, entryLineOffset, bGMTAEnabled, bGMTAShowZones, bGMTAPeriod, highTFLineWidth, bGMTAPeriodType, bGMTABuy, bGMTASell, bGTrend, buyZoneAlarm, sellZoneAlarm, longColor, shortColor, mainTFLineWidth);
		}

		public Indicators.BuySideGlobal.BSDSupplyDemand BSDSupplyDemand(ISeries<double> input , Brush supplyStrong, Brush supplyRetouch, Brush supplyZoneBorder, Brush demandStrong, Brush demandRetouch, Brush demandZoneBorder, Brush textColor, int strongOpacity, int retouchOpacity, bool showHistory, bool showOnlyPriorZones, bool recolorRetouch, bool extendZone, bool displayZoneConfirm, int extendZoneMinutes, int priorZoneDaysBack, int valueGapFactor, bool farEdgePrice, bool mainEdgePrice, bool zoneHeight, bool retestEnabled, string retestAlert)
		{
			return indicator.BSDSupplyDemand(input, supplyStrong, supplyRetouch, supplyZoneBorder, demandStrong, demandRetouch, demandZoneBorder, textColor, strongOpacity, retouchOpacity, showHistory, showOnlyPriorZones, recolorRetouch, extendZone, displayZoneConfirm, extendZoneMinutes, priorZoneDaysBack, valueGapFactor, farEdgePrice, mainEdgePrice, zoneHeight, retestEnabled, retestAlert);
		}

		public Indicators.BuySideGlobal.BSDTrailingStop BSDTrailingStop(ISeries<double> input , Brush upcolor1, int alpha, int beta, int gamma, bool colorbar, bool smooth, Brush dncolor1, Brush flatcolor1)
		{
			return indicator.BSDTrailingStop(input, upcolor1, alpha, beta, gamma, colorbar, smooth, dncolor1, flatcolor1);
		}

		public Indicators.BuySideGlobal.BSDZoneEntrySignals BSDZoneEntrySignals(ISeries<double> input , bool retestAsStrongZones, int retestCountStrongZones, int breakoutMinRestRequired, bool resetZonesForNewTradingDay, bool strongZoneBreakAndRetest, bool higherHighsAndLowerLows, bool zoneBreakAndZoneSwap, bool signalBreakAndRestart, bool strongZoneBounce)
		{
			return indicator.BSDZoneEntrySignals(input, retestAsStrongZones, retestCountStrongZones, breakoutMinRestRequired, resetZonesForNewTradingDay, strongZoneBreakAndRetest, higherHighsAndLowerLows, zoneBreakAndZoneSwap, signalBreakAndRestart, strongZoneBounce);
		}

	}
}

#endregion
